using System;

class Pierwiastek
{
  public static void Main(string[] args)
  {
    double parametrA, parametrB, parametrC;

    if(args.Length < 3)
    {
      Console.WriteLine(
        "WywoĹ‚anie programu: pierwiastek.exe parametrA parametrB parametrC");
      return;
    }

    try
    {
      parametrA = Double.Parse(args[0]);
      parametrB = Double.Parse(args[1]);
      parametrC = Double.Parse(args[2]);
    }
    catch(Exception)
    {
      Console.WriteLine(
        "Jeden z parametrĂłw rĂłwnania nie jest poprawnÄ… liczbÄ…!");
      return;
    }

    Console.WriteLine("Wprowadzone parametry rĂłwnania:\n");
    Console.WriteLine("A: " + parametrA + " B: " + parametrB + 
                      " C: " + parametrC + "\n");

    if (parametrA == 0)
    {
      Console.WriteLine("To nie jest rĂłwnanie kwadratowe: A = 0!");
    }
    else
    {
      double delta = parametrB * parametrB - 4 * parametrA * parametrC;
      double wynik;

      if (delta < 0)
      {
        Console.WriteLine("Delta < 0.");
        Console.WriteLine(
          "Brak rozwiÄ…zaĹ„ w zbiorze liczb rzeczywistych.");
      }
      else if (delta == 0)
      {
        wynik = -parametrB / (2 * parametrA);
        Console.WriteLine("RozwiÄ…zanie: x = " + wynik);
      }
      else
      {
         wynik = (-parametrB + Math.Sqrt(delta)) / (2 * parametrA);
         Console.Write("RozwiÄ…zanie: x1 = " + wynik);
         wynik = (-parametrB - Math.Sqrt(delta)) / (2 * parametrA);
         Console.WriteLine(", x2 = " + wynik);
      }
    }
  }
}
